/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.LockException;
import oracle.ops.verification.framework.storage.PolicyException;
import oracle.ops.verification.framework.storage.SharedStorageSet;
import oracle.ops.verification.framework.storage.SharedStrategy;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.UnreliableSignatureException;
import oracle.ops.verification.framework.storage.sDisk;
import oracle.ops.verification.util.MultiNodeException;

public class sDiskSharedStrategy
extends SharedStrategy {
    @Override
    public void findShared(Vector stList, Vector superSet) throws StorageException, MultiNodeException {
        MultiNodeException mne = null;
        List<String> discoveryASMPaths = null;
        super.findShared(stList, superSet);
        discoveryASMPaths = super.getDiscoveryASMPaths();
        Iterator setIter = superSet.iterator();
        while (setIter.hasNext()) {
            SharedStorageSet shSet = (SharedStorageSet)setIter.next();
            if (shSet.getNumNodes() < 2) continue;
            Vector diskList = shSet.getSharedSet();
            for (sDisk disk : diskList) {
                StorageException st;
                Trace.out((String)("sh set.size = " + shSet.size()));
                Trace.out((String)("disk " + disk + " node " + disk.getNode() + " sig status " + disk.isSignatureCertain()));
                if (!disk.isSignatureCertain()) {
                    shSet.remove(disk);
                    st = new UnreliableSignatureException("7020", disk.getNode(), (Object[])new String[]{disk.getName()}, disk.getName());
                    if (null == mne) {
                        mne = new MultiNodeException();
                    }
                    mne.addThrowable(disk.getNode(), st);
                }
                Trace.out((String)("Check policy/lock setting for: '" + disk.getName() + "'"));
                if (discoveryASMPaths != null) {
                    Trace.out((String)("discoveryASMPaths: '" + discoveryASMPaths.toString() + "'"));
                } else {
                    Trace.out((String)"discoveryASMPaths is null");
                }
                if (disk.isPolicySet()) {
                    Trace.out((String)"Disk policy is set");
                    if (disk.isOnASM() || discoveryASMPaths != null && discoveryASMPaths.contains(disk.getName())) {
                        Trace.out((String)("Disk not shareable: " + disk.toString()));
                        shSet.remove(disk);
                        st = new PolicyException("7037", disk.getNode(), (Object[])new String[]{disk.getName()}, disk.getName());
                        if (null == mne) {
                            mne = new MultiNodeException();
                        }
                        mne.addThrowable(disk.getNode(), st);
                    }
                }
                if (disk.isLockSet()) {
                    Trace.out((String)"Disk lock is set");
                    if (disk.isOnASM() || discoveryASMPaths != null && discoveryASMPaths.contains(disk.getName())) {
                        Trace.out((String)("Disk not shareable: " + disk.toString()));
                        shSet.remove(disk);
                        st = new LockException("7038", disk.getNode(), (Object[])new String[]{disk.getName()}, disk.getName());
                        if (null == mne) {
                            mne = new MultiNodeException();
                        }
                        mne.addThrowable(disk.getNode(), st);
                    }
                }
                Trace.out((String)("sh set.size = " + shSet.size()));
            }
            if (shSet.size() != 0) continue;
            setIter.remove();
        }
        if (null != mne) {
            throw mne;
        }
    }
}

